//---------------------------------------------------------------
// Fichero:  todo.asy
// Objetivo: Mostrar todas las rectas
// Fecha:    X.12.11.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Dimensiones de los ejes
real Xmin = -1, Xmax = 32, Ymin = -1, Ymax = 26, Extra = 1;

// Los extremos de las rectas
pair R1=(0,24), R2=(12,0);
pair S1=(0,16), S2=(24,0);
pair T1=(0,10), T2=(30,0);

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=2, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Las rectas
draw(R1 -- R2,1bp+magenta);
draw(S1 -- S2,1bp+magenta);
draw(T1 -- T2,1bp+magenta);
draw((Xmax+Extra,0) -- T2,1bp+magenta);
draw((0,Ymax+Extra) -- R1,1bp+magenta);

// Las ecuaciones
pen FormatoTexto = black+fontsize(8pt);

pair Pos=(13,8.5);
real Ang=-aTan(2/3);
label(rotate(Ang)*"$20x+30y=480$",Pos,FormatoTexto);

pair Pos=(25,2.5);
real Ang=-aTan(1/3);
label(rotate(Ang)*"$10x+30y=300$",Pos,FormatoTexto);

pair Pos=(4,18);
real Ang=-aTan(2);
label(rotate(Ang)*"$20x+10y=240$",Pos,FormatoTexto);

// Las flechas
pair n=0.5*unit((2,3));
pair d=unit(S2-S1);
draw(S1+9.5d+n -- S1+9.5d+4n,orange,Arrow());
draw(S2-8.5d+n -- S2-8.5d+4n,orange,Arrow());

pair n=0.5*unit((1,3));
pair d=unit(T2-T1);
draw(T1+21d+n -- T1+21d+4n,orange,Arrow());
draw(T2-0.5d+n -- T2-0.5d+4n,orange,Arrow());

pair n=0.5*unit((2,1));
pair d=unit(R2-R1);
draw(R1+2d+n -- R1+2d+4n,orange,Arrow());
draw(R2-14.5d+n -- R2-14.5d+4n,orange,Arrow());

pair n=0.5*(0,1);
draw((31,0)+n -- (31,0)+4n,orange,Arrow());

pair n=0.5*(1,0);
draw((0,25)+n -- (0,25)+4n,orange,Arrow());
