//---------------------------------------------------------------
// Fichero:  solucion.asy
// Objetivo: Mostrar la solución
// Fecha:    X.12.11.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Dimensiones de los ejes
real Xmin = -1, Xmax = 32, Ymin = -1, Ymax = 26, Extra = 1;

// Las cuatro esquinas del dibujo
pair ESW=(Xmin,Ymin), ENW=(Xmin,Ymax), ENE=(Xmax,Ymax), ESE=(Xmax,Ymin);

// Los vértices
pair ENW=(0,Ymax+Extra), ESE=(Xmax+Extra,0);
pair ENE=(Xmax+Extra,Ymax+Extra);
pair A=(0,24), B=(6,12), C=(18,5), D=(30,0);

// La solución
fill(ENW -- A -- B -- C -- D -- ESE -- ENE -- cycle, lightgreen);

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=2, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Los segmentos
draw(ENW -- A -- B -- C -- D -- ESE,1bp+deepgreen);

// Las recta que da la solución
pair v=(7,-5);
draw(B+1.5v -- B-0.5v, red);

// Los puntos
dot(A,4bp+heavygreen);
label("P",A,NE,black+fontsize(10pt));
dot(B,4bp+heavygreen);
label("Q",B,NE,black+fontsize(10pt));
dot(C,4bp+heavygreen);
label("R",C,NE,black+fontsize(10pt));
dot(D,4bp+heavygreen);
label("S",D,NE,black+fontsize(10pt));
