//---------------------------------------------------------------
// Fichero:  area.asy
// Objetivo: Mostrar el área factible
// Fecha:    J.13.11.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Dimensiones de los ejes
real Xmin = -15, Xmax = 205, Ymin = -15, Ymax = 165, Extra = 0;

// Los vértices de la zona
pair O=(0,0), P=(0,160), Q=(80,140), R=(160,60), S=(200,0);

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=20, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(8pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// La zona
filldraw(O -- P -- Q -- R -- S -- cycle, lightgreen, heavygreen);

// Los puntos
dot(O,5bp+heavygreen);
label("O",O,SW,black+fontsize(10pt));
dot(P,5bp+heavygreen);
label("P",P,NE,black+fontsize(10pt));
dot(Q,5bp+heavygreen);
label("Q",Q,NE,black+fontsize(10pt));
dot(R,5bp+heavygreen);
label("R",R,NE,black+fontsize(10pt));
dot(S,5bp+heavygreen);
label("S",S,NE,black+fontsize(10pt));
