//---------------------------------------------------------------
// Fichero:  solucion2.asy
// Objetivo: Mostrar la solución 2
// Fecha:    L.24.11.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(10cm);

// Dimensiones de los ejes
real Xmin = -2, Xmax = 40, Ymin = -2, Ymax = 25, Extra = 0.25;

// Los extremos de las rectas
pair R1=(-5,22.5), R2=(44,-2);
pair S1=(14,25), S2=(24.8,-2);

// Las rectas
draw(R1 -- R2,1.5bp+magenta);
draw(S1 -- S2,1.5bp+magenta);

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=5, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(8pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// La solución
pair A=(0,0), B=(24,0), C=(20,10), D=(0,20);
filldraw(A -- B -- C -- D -- cycle, lightgreen, 1.5bp+heavygreen);

// Las flechas
pair v=-1*unit((1,2));
draw(R1+v -- R1+3v,magenta,Arrow());
draw(R2+v -- R2+3v,magenta,Arrow());
pair v=-1*unit((5,2));
draw(S1+v -- S1+3v,magenta,Arrow());
draw(S2+v -- S2+3v,magenta,Arrow());

// Las ecuaciones
label(rotate(-aTan(2.5))*"$5x+2y=120$",(18,18),fontsize(8pt));
label(rotate(-aTan(0.5))*"$x+2y=40$",(30,6.5),fontsize(8pt));

// Los puntos
pen FormatoPunto=4bp+deepgreen;
dot (A,FormatoPunto);
dot (B,FormatoPunto);
dot (C,FormatoPunto);
dot (D,FormatoPunto);
