//---------------------------------------------------------------
// Fichero:  todo.asy
// Objetivo: Mostrar las tres rectas
// Fecha:    J.23.10.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.8cm);

// Dimensiones de los ejes
real Xmin = -5, Xmax = 5, Ymin = -2, Ymax = 3, Extra = 0.25;

// Las cuatro esquinas del dibujo
pair ESW=(Xmin,Ymin), ENW=(Xmin,Ymax), ENE=(Xmax,Ymax), ESE=(Xmax,Ymin);

// Los extremos de las rectas
pair R1=(-4,-2), R2=(1,3);
pair S1=(-1.5,3), S2=(5,-4/3);
pair T1=(-5,-4/3), T2=(5,1/3);

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),1bp+gray));

// Grosor de las líneas
defaultpen(1);

// Los ejes
draw((0,Ymin-Extra) -- (0,Ymax+Extra));
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Las rectas
pen Punteado = linetype(new real[] {2,2});
draw(R1 -- R2,1.5bp+magenta+Punteado);
draw(S1 -- S2,1.5bp+magenta);
draw(T1 -- T2,1.5bp+magenta);

// Las flechas
pair v=0.2*unit((1,-1));
draw(R1+v -- R1+3v,blue,Arrow());
draw(R2+v -- R2+3v,blue,Arrow());
pair v=0.2*unit((-2,-3));
draw(S1+v -- S1+3v,blue,Arrow());
draw(S2+v -- S2+3v,blue,Arrow());
pair v=0.2*unit((-1,6));
draw(T1+v -- T1+3v,blue,Arrow());
draw(T2+v -- T2+3v,blue,Arrow());

// Las ecuaciones
path Caja=box((-1.25,-0.25),(1.25,0.25));

pair Pos=(-1.5,0.5)+0.4*unit((-1,1));
fill(shift(Pos)*rotate(45)*Caja,white);
label(rotate(45)*"$x-y+2=0$",Pos,fontsize(10pt));

pair Pos=(1.5,1)+0.4*unit((1,1));
fill(shift(Pos)*rotate(-aTan(2/3))*Caja,white);
label(rotate(-aTan(2/3))*"$2x+3y=6$",Pos,fontsize(10pt));

pair Pos=(0,-0.5)+0.4*unit((1,-6));
fill(shift(Pos)*rotate(aTan(1/6))*xscale(0.85)*Caja,white);
label(rotate(aTan(1/6))*"$x-6y=3$",Pos,fontsize(10pt));
