//---------------------------------------------------------------
// Fichero:  solucion2.asy
// Objetivo: Mostrar la solución 2
// Fecha:    L.27.10.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 6, Ymin = 0, Ymax = 4, Extra = 0.25;

// Los vértices de la solución
pair A=(1,1), B=(5,1), C=(5,3), D=(1,3);

// La solución
fill(A -- B -- C -- D -- cycle, lightgreen);

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),1bp+gray));

// Grosor de las líneas
defaultpen(1);

// Los ejes
draw((0,Ymin-Extra) -- (0,Ymax+Extra));
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Las semirrectas
pen Punteado = linetype(new real[] {2,2});
draw(A -- D,1.5bp+white);
draw(A -- D,1.5bp+heavygreen+Punteado);
draw(B -- C,1.5bp+white);
draw(B -- C,1.5bp+heavygreen+Punteado);
draw(A -- B,1.5bp+heavygreen);
draw(C -- D,1.5bp+heavygreen);

// Los puntos
dot (A, 5bp+gray);
dot (A, 3bp+white);
dot (B, 5bp+gray);
dot (B, 3bp+white);
dot (C, 5bp+gray);
dot (C, 3bp+white);
dot (D, 5bp+gray);
dot (D, 3bp+white);
