//---------------------------------------------------------------
// Fichero:  solucion5.asy
// Objetivo: Mostrar la solución 5
// Fecha:    S.25.10.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.8cm);

// Dimensiones de los ejes
real Xmin = -10, Xmax = 4, Ymin = -3, Ymax = 3, Extra = 0.25;

// Los vértices de la solución
pair A=(-9,2), B=(3,2), C=(3,-2);

// La solución
fill(A -- B -- C -- cycle, lightgreen);

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),1bp+gray));

// Grosor de las líneas
defaultpen(1);

// Los ejes
draw((0,Ymin-Extra) -- (0,Ymax+Extra));
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El triángulo
pen Punteado = linetype(new real[] {2,2});
draw(A -- B -- C,1.5bp+white);
draw(A -- B -- C,1.5bp+heavygreen+Punteado);
draw(A -- C,1.5bp+heavygreen);

// Los puntos
dot (A, 5bp+gray);
dot (A, 3bp+white);
dot (B, 5bp+gray);
dot (B, 3bp+white);
dot (C, 5bp+gray);
dot (C, 3bp+white);
