//---------------------------------------------------------------
// Fichero:  solucion4.asy
// Objetivo: Mostrar la solución 4
// Fecha:    S.25.10.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.8cm);

// Dimensiones de los ejes
real Xmin = -5, Xmax = 5, Ymin = -2, Ymax = 4, Extra = 0.25;

// Las cuatro esquinas del dibujo
pair ESW=(Xmin,Ymin), ENW=(Xmin,Ymax), ENE=(Xmax,Ymax), ESE=(Xmax,Ymin);

// Los extremos de las semirrectas
pair A=(2,3), B=(1,-1);

// La solución
fill(ENE -- (4,4) -- A -- B -- (2.5,-2) -- ESE -- cycle, lightgreen);

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),1bp+gray));

// Grosor de las líneas
defaultpen(1);

// Los ejes
draw((0,Ymin-Extra) -- (0,Ymax+Extra));
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Las semirrectas
pen Punteado = linetype(new real[] {2,2});
draw((4,4) -- A -- B -- (2.5,-2),1.5bp+heavygreen+Punteado);

// Los puntos
dot (A, 5bp+gray);
dot (A, 3bp+white);
dot (B, 5bp+gray);
dot (B, 3bp+white);
