//---------------------------------------------------------------
// Fichero:  solucion1.asy
// Objetivo: Mostrar la solución 1
// Fecha:    S.25.10.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.8cm);

// Dimensiones de los ejes
real Xmin = -4, Xmax = 5, Ymin = -2, Ymax = 4, Extra = 0.25;

// Las cuatro esquinas del dibujo
pair ESW=(Xmin,Ymin), ENW=(Xmin,Ymax), ENE=(Xmax,Ymax), ESE=(Xmax,Ymin);

// Los extremos de las semirrectas
pair A=(-4,-1), B=(0,3), C=(5,-3/4);

// La solución
fill(ESW -- A -- B -- C -- ESE -- cycle, lightgreen);

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),1bp+gray));

// Grosor de las líneas
defaultpen(1);

// Los ejes
draw((0,Ymin-Extra) -- (0,Ymax+Extra));
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Las semirrectas
draw(A -- B -- C,1.5bp+heavygreen);

// El origen de la semirrecta
dot (B, 5bp+heavygreen);
