//---------------------------------------------------------------
// Fichero:  solucion6.asy
// Objetivo: Mostrar la solución 6
// Fecha:    M.21.10.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.8cm);

// Dimensiones de los ejes
real Xmin = -4, Xmax = 5, Ymin = -3, Ymax = 2, Extra = 0.25;

// Las cuatro esquinas del dibujo
pair ESW=(Xmin,Ymin), ENW=(Xmin,Ymax), ENE=(Xmax,Ymax), ESE=(Xmax,Ymin);

// Los extremos de la recta
pair R1=(-1,2), R2=(3,-3);

// El semiplano
fill(R1 -- ENE -- ESE -- R2 -- cycle, lightgreen);

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),1bp+gray));

// Grosor de las líneas
defaultpen(1);

// Los ejes
draw((0,Ymin-Extra) -- (0,Ymax+Extra));
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// La recta
pen Punteado = linetype(new real[] {2,2});
draw(R1 -- R2,1.5bp+heavygreen+Punteado);
