#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  newton.py
# Objetivo: Da el desarrollo del binomio de Newton
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    X.8.10.2025
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
# Ejemplo:  ./newton.py 2x3 -5 4
# Nota:     El primer sumando lleva "x" y el segundo no
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

# Para leer la línea de órdenes
import sys

# factorial()
import math

#------------------------------------------------
# Funciones
#------------------------------------------------

def Combinaciones(n,k):
    return math.factorial(n)/math.factorial(k)/math.factorial(n-k)

#------------------------------------------------
# El programa
#------------------------------------------------

# Leemos los datos de la línea de órdenes
Mon1 = sys.argv[1]
Mon2 = sys.argv[2]
n = int(sys.argv[3])

# Estudiamos el signo del segundo monomio
Sig2 = -1 if Mon2[0] == '-' else 1

# Ajustamos el texto del segundo monomio
if Sig2 == 1: Mon2 = '+' + Mon2

# Mostramos el enunciado
print '(' + Mon1 + Mon2 + ')^' + str(n)

# Solo tiene "x" el primer monomio, la buscamos
Pos = Mon1.find('x')

# El número hasta la "x" es el coeficiente
Coef = 1 if Pos == 0 else int(Mon1[0:Pos])

# El número desde la "x" es el exponente
Exp = 1 if Pos == len(Mon1)-1 else int(Mon1[Pos+1:])

# El segundo monomio es un número
Mon2 = int(Mon2)

# Preparamos la respuesta
Respuesta = ''

# Iteramos
for k in range(0,n+1):
    Monomio = ''

    Coeficiente = Combinaciones(n,k) * pow(Coef,n-k) * pow(Mon2,k)
    if Coeficiente < 0:
        Monomio = str(Coeficiente)
    else:
        if k > 0:
            Monomio = '+'
        if Coeficiente != 1:
            Monomio = Monomio + str(Coeficiente)

    if k != n:
        Monomio = Monomio + 'x'
    else:
        if Coeficiente == 1: Monomio = Monomio + '1'

    Exponente = Exp * (n-k)
    if Exponente > 1:
        Monomio = Monomio + str(Exponente)

    Respuesta = Respuesta + Monomio

# Damos el resultado
print Respuesta
