#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  razones.py
# Objetivo: Dar todas las razones trigonométricas a partir de una
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    D.30.3.2025
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
#--------------------------------------------------------------------

#------------------------------------------------
# Uso del programa:
#
# Solo se consideran ángulos agudos
# Las razones trigonométricas son sen, cos, tg, sec, csc y ctg
#------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

# Para leer la línea de órdenes
import sys

# Para las funciones trigonométricas
import math

#------------------------------------------------
# El programa
#------------------------------------------------

# Leemos los datos de la línea de órdenes
Razon = sys.argv[1]
Valor = float(sys.argv[2])

# Calculamos el ángulo
if Razon == 'sen': Ang = math.asin(Valor)
if Razon == 'cos': Ang = math.acos(Valor)
if Razon == 'tg':  Ang = math.atan(Valor)
if Razon == 'sec': Ang = math.acos(1/Valor)
if Razon == 'csc': Ang = math.asin(1/Valor)
if Razon == 'ctg': Ang = math.atan(1/Valor)

# Damos los resultados
print 'sen =', math.sin(Ang);
print 'cos =', math.cos(Ang);
print 'tg  =', math.tan(Ang);
print 'sec =', 1/math.cos(Ang);
print 'csc =', 1/math.sin(Ang);
print 'ctg =', 1/math.tan(Ang);
