//---------------------------------------------------------------
// Fichero:  cartabon.asy
// Objetivo: Mostrar un triángulo rectángulo con forma de cartabón
// Fecha:    M.18.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle() markrightangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(Cos(30),0), C=dir(30);

// El formato de texto
pen Formato=black+fontsize(10pt);

// Los ángulos
markangle(Label("$30^\circ$",Formato), radius=10mm, B, A, C, 1bp+blue);
markangle(Label("$60^\circ$",Formato), radius=7mm, A, C, B, 1bp+blue);
markrightangle(A, B, C, 2mm, 1bp+gray);

// El triángulo
draw(A -- B -- C -- cycle);

// La hipotenusa
label("$1$", (A+C)/2, NW, Formato);
label("$\frac{1}{2}$", (B+C)/2, E, Formato);
label("x", (A+B)/2, S, Formato);
