//---------------------------------------------------------------
// Fichero:  ilustracion1.asy
// Objetivo: Mostrar la ilustración de la resolución 1
// Fecha:    M.11.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle() markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(0.5);

// El vértice de arriba
pair A=(0,0.67);

// El vértice de la izquierda
pair B=(-2.07,0);

// El vértice de la derecha
pair C=(0.93,0);

// La proyección de A sobre BC
pair D=(0,0);

// Los ángulos
pen FormAng=fontsize(6pt)+deepgreen;
pen FormArc=0.25bp+deepgreen;
markangle(Label("$18^\circ$",FormAng), radius=10mm, D, B, A, FormArc);
markangle(Label("$36^\circ$",FormAng), radius=5mm, A, C, D, FormArc);

// La separación entre las flechas y el objeto
real Separacion = 0.15;

// Las flechas que marcan los segmentos
pen FormatoFlecha=mediumblue+0.25bp;
draw(B+Separacion*(0,-1) -- D+Separacion*(0,-1), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));
draw(C+Separacion*(0,-1) -- D+Separacion*(0,-1), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));
draw(C+Separacion*(0,-2.5) -- B+Separacion*(0,-2.5), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));

// Los textos
pen FormatoTexto=fontsize(6pt)+Helvetica(series="n",shape="n");
label("A", A, N, black+FormatoTexto);
label("B", B, W, black+FormatoTexto);
label("C", C, E, black+FormatoTexto);
label("D", D, NE, black+FormatoTexto);
label("h", (A+D)/2+Separacion*(-0.5,-0.2), red+FormatoTexto);
label("3-x", (B+D)/2+Separacion*(0,-1.5), red+FormatoTexto);
label("x", (C+D)/2+Separacion*(0,-1.5), red+FormatoTexto);
label("3", (C+B)/2+Separacion*(0,-3), deepgreen+FormatoTexto);

// Dibujamos el triángulo
draw(A--B--C--A);

// La altura
draw(A -- D, gray);
markrightangle(A, D, B, 2mm, 0.5bp+black);

// Marcamos los puntos importantes
pen FormatoPunto=3bp+black;
dot(A,FormatoPunto);
dot(B,FormatoPunto);
dot(C,FormatoPunto);
dot(D,FormatoPunto);
