//---------------------------------------------------------------
// Fichero:  figura1.asy
// Objetivo: Realizar la figura 1
// Fecha:    S.22.2.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,1.5cm);

// Grosor de las líneas
defaultpen(0.5);

// La circunferencia
draw(circle((0,0),1));

// Dos puntos de la circunferencia
pair A=dir(aSin(0.7)), B=dir(-aSin(0.7));

// Los segmentos
draw(A -- B);
draw((0,0) -- A);
draw((0,0) -- B);

// El formato de texto
pen Formato=black+fontsize(5pt);

// El ángulo
markangle(Label("$\alpha$",Formato), radius=2mm, B, (0,0), A, blue);

// Los textos
label("7", (A+B)/2, E, Formato);
label("5", A/2, NW, Formato);
label("5", B/2, SW, Formato);
