//---------------------------------------------------------------
// Fichero:  figura.asy
// Objetivo: Mostrar un triángulo rectángulo
// Fecha:    V.14.2.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

//markangle() y markrightangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(4,0), C=(4,2.5);

// El formato de texto
pen Formato=black+fontsize(12pt);

// El triángulo
draw(A -- B -- C -- cycle);

// Los ángulos
markangle(Label("$\alpha$",Formato), radius=10mm, B, A, C, 1bp+blue);
markrightangle(A, B, C, 2mm, 1bp+gray);

// La descripción de los lados
Formato=black+fontsize(10pt);
label("Cateto contiguo a $\alpha$", (A+B)/2, S, Formato);
label(rotate(90)*"Cateto opuesto a $\alpha$", (B+C)/2, E, Formato);
label(rotate(degrees(C))*"Hipotenusa", (A+C)/2, N+0.5W, Formato);
