//---------------------------------------------------------------
// Fichero:  figura5.asy
// Objetivo: Mostrar la figura 5
// Fecha:    X.19.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.5cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=(0,0), B=(3*sqrt(3),0), C=(3*sqrt(3),3), D=(0,3);

// El punto auxiliar
pair P=(3/sqrt(3),3);

// Los textos
pen FormatoTexto=fontsize(8pt)+Helvetica(series="b",shape="n");
label("3", (B+C)/2, E, deepgreen+FormatoTexto);

// Dibujamos el triángulo
fill(A -- C -- P -- cycle, lightgray);

// Los ángulos
pen FormAng=fontsize(8pt)+deepgreen;
pen FormArc=0.5bp+deepgreen;
markangle(Label("$\alpha$",FormAng), radius=7mm, B, A, C, FormArc);
markangle(Label("$\alpha$",FormAng), radius=12mm, C, A, P, FormArc);
markangle(Label("$\alpha$",FormAng), radius=7mm, P, A, D, FormArc);

// Dibujamos la figura
draw(A -- B -- C -- D -- A);
draw(A -- C);
draw(A -- P);
