//---------------------------------------------------------------
// Fichero:  figura4.asy
// Objetivo: Mostrar la figura 4
// Fecha:    X.19.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.5cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=(0,0), B=(7,0), C=(6,sqrt(3)), D=(1,sqrt(3));

// Los ángulos
pen FormAng=fontsize(8pt)+deepgreen;
pen FormArc=0.5bp+deepgreen;
markangle(Label("$60^\circ$",FormAng), radius=5mm, B, A, D, FormArc);
markangle(Label("$60^\circ$",FormAng), radius=5mm, C, B, A, FormArc);

// Los textos
pen FormatoTexto=fontsize(8pt)+Helvetica(series="b",shape="n");
label("7", (A+B)/2, S, deepgreen+FormatoTexto);
label("5", (C+D)/2, N, deepgreen+FormatoTexto);

// Dibujamos el trapecio
draw(A -- B -- C -- D -- A);
