//---------------------------------------------------------------
// Fichero:  figura3.asy
// Objetivo: Mostrar la figura 3
// Fecha:    M.18.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle() markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.5cm);

// Grosor de las líneas
defaultpen(1);

// El vértice de la izquierda
pair A=(0,0);

// El vértice de la derecha
pair B=(4*sqrt(3),0);

// El vértice de arriba
pair C=(2*sqrt(3),6);

// El punto medio de abajo
pair Q=B/2;

// El punto de la derecha un poco arriba
pair P=(4*sqrt(3),4);

// Los ángulos
pen FormAng=fontsize(8pt)+deepgreen;
pen FormArc=0.5bp+deepgreen;
markangle(Label("$30^\circ$",FormAng), radius=14mm, P, A, C, FormArc);
markangle(Label("$30^\circ$",FormAng), radius=10mm, B, A, P, FormArc);
markrightangle(C, Q, A, 4mm, 1bp+gray);
markrightangle(P, B, A, 4mm, 1bp+gray);

// La separación entre las flechas y los elementos
real Separacion = 0.2;

// Las flechas
pen FormatoFlecha=mediumblue+0.75bp;
draw(B+Separacion*(1,0) -- P+Separacion*(1,0), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));
draw(Q+Separacion*(1,0) -- C+Separacion*(1,0), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));
draw(P+Separacion*(1,1) -- C+Separacion*(1,1), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));

// Los textos
pen FormatoTexto=fontsize(8pt)+Helvetica(series="b",shape="n");
label("4", (B+P)/2+Separacion*(2,0), deepgreen+FormatoTexto);
label("6", (Q+C)/2+Separacion*(2,0), deepgreen+FormatoTexto);
label("x", (P+C)/2+Separacion*(2,2), red+FormatoTexto);

// Dibujamos las líneas
draw(A -- B -- P -- A);
draw(A -- Q -- C -- A);
draw(P -- C);
