//---------------------------------------------------------------
// Fichero:  figura6b.asy
// Objetivo: Representar una flor formada por pentágonos
// Fecha:    L.17.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.5cm);

// Grosor de las líneas
defaultpen(1);

// Un hexágono regular
path Hexagono=scale(2)*rotate(30)*polygon(6);

// La flor
guide Flor;

// Recorremos el hexágono formando la flor
pair P, Ant, Sig;
for ( int i=0 ; i<7 ; ++i )
    {
    // El punto del hexágono
    P=point(Hexagono,i);
    real ang=degrees(P);

    // Los puntos anterior y siguiente
    Ant=P+dir(ang-60);
    Sig=P+dir(ang+60);

    // El radio
    draw((0,0) -- P, gray);

    // Una parte de la flor
    Flor=Flor--Ant;
    Flor=Flor--P;
    Flor=Flor--Sig;
    }

// Representamos la flor
draw(Flor);
