//---------------------------------------------------------------
// Fichero:  figura8b.asy
// Objetivo: Ilustrar la figura 8b
// Fecha:    V.7.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,4cm);

// Grosor de las líneas
defaultpen(1);

// El pentágono
path Pentagono = polygon(5);

// Los cinco pentágonos que rodean al pentágono principal
for ( int i=0 ; i<5 ; ++i )
    {
    // Dos puntos consecutivos
    pair V1=point(Pentagono, i+1), V2=point(Pentagono, i);

    // El punto medio del lado
    pair M=(V1+V2)/2;

    // El vértice opuesto
    pair Opuesto = point(Pentagono, i+3);

    // El vector que une un vértice con el punto medio del lado opuesto
    pair Vector = M - Opuesto;

    // Marcamos el pentágono
    draw(shift(0.9*Vector)*rotate(36+72*i)*Pentagono);
    }

// Marcamos el pentágono principal
draw(Pentagono, 2bp+red);

