//---------------------------------------------------------------
// Fichero:  triangulo.asy
// Objetivo: Mostrar un triángulo rectángulo con notación general
// Fecha:    J.27.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle() markrightangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(4,0), B=(0,0), C=(4,3);

// El formato de texto
pen Formato=black+fontsize(10pt);

// Los ángulos
markangle(Label("$\hat{B}$",Formato), radius=7mm, A, B, C, 1bp+blue);
markangle(Label("$\hat{C}$",Formato), radius=5mm, B, C, A, 1bp+blue);
markrightangle(B, A, C, 2mm, 1bp+gray);

// El triángulo
draw(A -- B -- C -- cycle);

// Los lados
label("a", (B+C)/2, NW, Formato);
label("b", (A+C)/2, E, Formato);
label("c", (A+B)/2, S, Formato);
