//---------------------------------------------------------------
// Fichero:  enunciado06.asy
// Objetivo: Ilustrar el enunciado 6
// Fecha:    D.23.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle() markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,4cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(8,0), C=(0,26);

// Los ángulos
pen FormAng=fontsize(6pt)+black;
pen FormArc=0.5bp+black;
markangle(Label("$73^\circ$",FormAng), radius=2mm, C, B, A, FormArc);
markangle(Label("$\hat{C}$",FormAng), radius=10mm, A, C, B, FormArc);
markrightangle(B, A, C, 2mm, 0.5bp+gray);

// El triangulo
draw(A -- B -- C -- cycle);

// Los nombres
pen FormatoTexto=black+fontsize(8pt)+Helvetica(series="b",shape="n");
label("8", (A+B)/2, S, FormatoTexto);
label("a", (B+C)/2, NE, FormatoTexto);
label("b", (A+C)/2, W, FormatoTexto);

// Los puntos
pen FormatoPunto=black+3bp;
dot(Label('A',FormatoTexto), A, SW, FormatoPunto);
dot(Label('B',FormatoTexto), B, SE, FormatoPunto);
dot(Label('C',FormatoTexto), C, N, FormatoPunto);
