//---------------------------------------------------------------
// Fichero:  enunciado04.asy
// Objetivo: Ilustrar el enunciado 4
// Fecha:    D.23.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle() markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3.5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(11.78,0), C=(0,5.49);

// Los ángulos
pen FormAng=fontsize(12pt)+black;
pen FormArc=0.5bp+black;
markangle(Label("$25^\circ$",FormAng), radius=12mm, C, B, A, FormArc);
markangle(Label("$\hat{C}$",FormAng), radius=8mm, A, C, B, FormArc);
markrightangle(B, A, C, 4mm, 0.5bp+gray);

// El triangulo
draw(A -- B -- C -- cycle);

// Los nombres
pen FormatoTexto=black+fontsize(12pt)+Helvetica(series="b",shape="n");
label("c", (A+B)/2, S, FormatoTexto);
label("13", (B+C)/2, NE, FormatoTexto);
label("b", (A+C)/2, W, FormatoTexto);

// Los puntos
pen FormatoPunto=black+3bp;
dot(Label('A',FormatoTexto), A, SW, FormatoPunto);
dot(Label('B',FormatoTexto), B, SE, FormatoPunto);
dot(Label('C',FormatoTexto), C, N, FormatoPunto);
