//---------------------------------------------------------------
// Fichero:  enunciado2.asy
// Objetivo: Mostrar la figura del enunciado 2
// Fecha:    D.16.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle() markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.8cm);

// Grosor de las líneas
defaultpen(1);

// Los datos del enunciado
int Separ=57, Menor=39, Mayor=66;

// Lo que pide el problema
real d=Separ*Tan(Menor)/(Tan(Mayor)-Tan(Menor));
real h=d*Tan(Mayor);

// El vértice de la izquierda
pair A=(0,0);

// El vértice de la derecha
pair B=(Separ+d,0);

// El vértice de arriba
pair C=(Separ+d,h);

// El primer punto de observación
pair D=(Separ,0);

// Los ángulos
pen FormAng=fontsize(12pt)+deepgreen;
pen FormArc=0.5bp+deepgreen;
markangle(Label("$"+string(Menor)+"^\circ$",FormAng),
          radius=15mm, D, A, C, FormArc);
markangle(Label("$"+string(Mayor)+"^\circ$",FormAng),
          radius=10mm, B, D, C, FormArc);
markrightangle(C, B, A, 4mm, 1bp+gray);

// La separación entre las flechas y los elementos
real Separacion = 5;

// Las flechas
pen FormatoFlecha=mediumblue+0.75bp;
draw(A+Separacion*(0,-1) -- D+Separacion*(0,-1), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));
draw(B+Separacion*(0,-1) -- D+Separacion*(0,-1), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));
draw(B+Separacion*(1,0) -- C+Separacion*(1,0), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));

// Los textos
pen FormatoTexto=fontsize(12pt)+Helvetica(series="b",shape="n");
label("h", (B+C)/2+Separacion*(2,0), red+FormatoTexto);
label("d", (B+D)/2+Separacion*(0,-2), red+FormatoTexto);
label(string(Separ), (A+D)/2+Separacion*(0,-2), deepgreen+FormatoTexto);

// Dibujamos las líneas
draw(A -- B -- C -- A);
draw(C -- D);

// Marcamos los puntos
pen FormatoPunto=3bp+black;
dot(A,FormatoPunto);
dot(B,FormatoPunto);
dot(C,FormatoPunto);
dot(D,FormatoPunto);
