//---------------------------------------------------------------
// Fichero:  exterior.asy
// Objetivo: Rectas tangentes por un punto exterior a la circunferencia
// Fecha:    V.4.7.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición del centro y el punto exterior
pair T=(0,0), A=(-2,2);

// La circunferencia
path C=circle(T,1);

// La circunferencia auxiliar
pair M=(T+A)/2;
real r=abs(A-T)/2;
path Aux=circle(M,r);

// Los puntos de tangencia
pair[] PT=intersectionpoints(C,Aux);

// Para cada punto de tangencia
for (int i=0 ; i<2 ; ++i)
    {
    pair v=PT[i]-A;
    draw(A-0.1v -- PT[i]+0.2v, deepgreen);
    dot(PT[i],2bp+black);
    }

// La circunferencia
draw(C);

// El punto
dot(A, 4bp+blue);
