//---------------------------------------------------------------
// Fichero:  circunferencia.asy
// Objetivo: Representar una circunferencia
// Fecha:    D.29.6.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.75cm);

// Grosor de las líneas
defaultpen(1);

// Definición del centro y un punto
pair T=(0,0), P=dir(50);

// La circunferencia
draw(circle(T,1));

// El radio
draw(T -- P, 2bp+blue);

// El centro
dot(T, 4bp+red);

// El punto
dot(P, 4bp+red);

// Los nombres
pen FormatoTexto=black+fontsize(12pt);
label("C",dir(135),NW,FormatoTexto);
label("T",T,W,FormatoTexto);
label("P",P,NE,FormatoTexto);
label("r",P/2,NW,FormatoTexto);
