//---------------------------------------------------------------
// Fichero:  dibujo.asy
// Objetivo: Representar el problema
// Fecha:    X.25.6.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Los puntos
pair A=(-1,2), B=(11,-7), C=(23,9), I=(10,0);

// La bisectriz del ángulo en A
pair Vz=unit(B-A)+unit(C-A);
draw (A -- A+12*Vz, blue);

// La bisectriz del ángulo en B
pair Vw=unit(A-B)+unit(C-B);
draw (B -- B+11*Vw, blue);

// El triángulo
draw(A -- B -- C -- cycle);

// Marcamos los puntos
pen FormatoTexto=black+fontsize(8pt);
pen FormatoPunto=3bp+black;
dot(A,FormatoPunto);
dot(B,FormatoPunto);
dot(C,FormatoPunto);
dot(I,4bp+deepgreen);
label("A",A,W,FormatoTexto);
label("B",B,S,FormatoTexto);
label("C",C,N,FormatoTexto);
label("I",I,NE,FormatoTexto);

// Nombres de las rectas
label("s",(A+C)/2,N,FormatoTexto);
label("t",(B+C)/2,SE,FormatoTexto);
label("r",(A+B)/2,SW,FormatoTexto);
label("z",A+12.5*Vz,FormatoTexto);
label("w",B+11.5*Vw,FormatoTexto);
