//---------------------------------------------------------------
// Fichero:  figura2.asy
// Objetivo: Representar la figura2
// Fecha:    S.14.6.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// La recta
pair A=(0,2), B=(7,0);
draw(A -- B);
label("r",B,2NW);

// Un punto y su proyección sobre la recta
pair H=(4,3);
pair Q=intersectionpoint(A -- B, H -- H+(-2,-7));

// La distancia
draw(H -- Q, 1.5bp+deepgreen);
label("d",(H+Q)/2,W);

// El ángulo recto
pair D=Q+0.3(B-A);
markrightangle(D, Q, H, 3mm, 0.5bp+blue);

// Marcamos los puntos
dot(H,3bp+black);
dot(Q,3bp+black);
label("H",H,E);
label("Q",Q,SW);
