//---------------------------------------------------------------
// Fichero:  vectores-normales.asy
// Objetivo: Representar los vectores normales de rectas paralelas
// Fecha:    X.28.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Grosor de las líneas
defaultpen(1);

// Los ejes de coordenadas
real Xmin = -2, Xmax = 6, Ymin = 0, Ymax = 4, Extra = 0.25;
draw((Xmin-Extra,0) -- (Xmax+Extra,0));
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El vector normal
dot((0,0), 3bp+deepgreen);
pair n=(-0.5,1.5);
draw((0,0) -- n, 1.25bp+deepgreen,Arrow(HookHead,5pt));
label("$\vec{n}$",1.2n,deepgreen+fontsize(10pt));

// El vector de dirección
pair v=(n.y,-n.x);

// La recta r
pair A=(-2,0.25), AF=A+5v;
pair A1=A+4v, A2=A1+(-1.3)*n;
draw(A -- AF, 1.5bp+blue);
label("r",AF,E,fontsize(12pt));
dot(A1, 3bp+orange);
draw(A1 -- A2, 1.25bp+orange,Arrow(HookHead,5pt));
label("$\vec{n}_r$",(A1+A2)/2,E,orange+fontsize(10pt));

// La recta s
pair A=(-2,2.3), AF=A+3.8v;
pair A1=A+2v, A2=A1+(-0.9)*n;
draw(A -- AF, 1.5bp+blue);
label("s",AF,1.5E,fontsize(12pt));
dot(A1, 3bp+orange);
draw(A1 -- A2, 1.25bp+orange,Arrow(HookHead,5pt));
label("$\vec{n}_s$",(A1+A2)/2,E,orange+fontsize(10pt));
