//---------------------------------------------------------------
// Fichero:  paralelas.asy
// Objetivo: Representar el problema de las rectas paralelas
// Fecha:    X.28.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// El vector de dirección
pair v=(9,1);

// La recta r
pair A1=(0,0), A2=A1+1.2v;
draw(A1 -- A2, 1.5bp+blue);
label("r",A2,E,fontsize(12pt));

// La recta s
pair A1=(0,2), A2=A1+1.2v;
draw(A1 -- A2, 1.5bp+deepgreen);
label("s",A2,E,fontsize(12pt));

// El punto A
pair A=A1+0.35v;
dot(A,blue+3bp);
label("A",A,N,black+fontsize(12pt));
