//---------------------------------------------------------------
// Fichero:  sialineados.asy
// Objetivo: Representar tres puntos alineados
// Fecha:    L.26.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.8cm);

// Grosor de las líneas
defaultpen(1);

// Los tres puntos
pair A=(0,0), B=(5,2), C=A+0.7(B-A);

// Los dos vectores
dot(A, 3bp+deepgreen);
draw(A -- B, 3.5bp+deepgreen,Arrow(HookHead,5pt));
pen FormatoTexto = deepgreen+fontsize(12pt);
pair Pos=(A+B)/2+0.4SE;
label("AB",Pos,FormatoTexto);
draw(Pos+(-0.2,0.15) -- Pos+(0.2,0.15), 0.5bp+deepgreen,Arrow(HookHead,2pt));
draw(A -- C, 1.5bp+deepred,Arrow(HookHead,5pt));
pen FormatoTexto = deepred+fontsize(12pt);
pair Pos=(A+C)/2+0.3NW;
label("AC",Pos,FormatoTexto);
draw(Pos+(-0.2,0.15) -- Pos+(0.2,0.15), 0.5bp+deepred,Arrow(HookHead,2pt));

// Los tres puntos
pen FormatoPunto=7bp+black;
pen FormatoTexto = black+fontsize(12pt);
dot(A,FormatoPunto);
dot(B,FormatoPunto);
dot(C,FormatoPunto);
label("A",A,SW,FormatoTexto);
label("B",B,E,FormatoTexto);
label("C",C,N,FormatoTexto);
