//---------------------------------------------------------------
// Fichero:  abscisa.asy
// Objetivo: Representar una recta paralela al eje de abscisas
// Fecha:    D.25.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Los ejes de coordenadas
real Xmin = -1, Xmax = 5, Ymin = -1, Ymax = 3, Extra = 0.25;
draw((Xmin-Extra,0) -- (Xmax+Extra,0));
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// La recta
draw((3,-1) -- (3,3), 1.5bp+blue);
label("s",(3,3),E,fontsize(12pt));

// El vector de dirección
dot((0,0), 3bp+deepgreen);
draw((0,0) -- (0,1), 1.25bp+deepgreen,Arrow(HookHead,5pt));
label("$\vec{v}_s$",(0,0.5),W,deepgreen+fontsize(8pt));

// El vector normal
draw((0,0) -- (1,0), 1.25bp+deepgreen,Arrow(HookHead,5pt));
label("$\vec{n}_s$",(0.5,0),S,deepgreen+fontsize(8pt));

// La abscisa en el origen
dot((3,0), 3bp+deepgreen);
label("(p,0)",(3,0),2SE,fontsize(8pt));
