//---------------------------------------------------------------
// Fichero:  justificacion.asy
// Objetivo: Justificar la ecuación explícita
// Fecha:    X.21.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Los ejes de coordenadas
real Xmin = -1, Xmax = 5.25, Ymin = 0, Ymax = 3.5, Extra = 0.25;
draw((Xmin-Extra,0) -- (Xmax+Extra,0));
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// La recta
pair Q=(0,1.5), v=(5,2);
draw(Q-0.2v -- Q+v, 1.5bp+blue);
label("r",Q+v,S,fontsize(8pt));

// El punto genérico
pair P=Q+0.8v;
pen Punteado = linetype(new real[] {2,2});
draw(Q -- (P.x,Q.y), Punteado+gray);
draw(P -- (P.x,0),gray);
draw(P -- (0,P.y),gray);
dot(P, 2.5bp+black);
dot((P.x,0), 2.5bp+black);
dot((0,P.y), 2.5bp+black);
dot((P.x,Q.y), 2.5bp+black);
label("x",(P.x,0),S,fontsize(8pt));
label("y",(0,P.y),W,fontsize(8pt));

// La ordenada en el origen
dot(Q, 3bp+deepgreen);
label("(0,q)",Q,NW,fontsize(6pt));

// La suma
label("q",(P.x,Q.y/2),E,fontsize(8pt));
label("mx",(P.x,(P.y+Q.y)/2),E,fontsize(8pt));
