//---------------------------------------------------------------
// Fichero:  vectorpendiente.asy
// Objetivo: Representar el vector de dirección y la pendiente
// Fecha:    M.13.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Los ejes de coordenadas
real Xmin = 0, Xmax = 6, Ymin = -1, Ymax = 2, Extra = 0.25;
draw((Xmin-Extra,0) -- (Xmax+Extra,0));
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// La recta
pair A=(1.5,-1), B=(6,2);
draw(A -- B, 1.5bp+blue);
label("r",B,2W,fontsize(12pt));

// El vector de dirección
pair v=0.4(B-A);
dot((0,0), 3bp+deepgreen);
draw((0,0) -- v, 1.25bp+deepgreen,Arrow(HookHead,5pt));
label("$\vec{v}_r$",v,N,deepgreen+fontsize(12pt));

// La separación entre la flecha y el objeto
real Sep = 0.2;

// Las flechas que marcan los segmentos
pen FormatoFlecha=mediumblue+0.5bp;
draw((0,0)+Sep*(0,-1) -- (v.x,0)+Sep*(0,-1), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.25mm));
draw((v.x,0)+Sep*(0.5,0) -- v+Sep*(0.5,0), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.25mm));

// Las componentes
pen FormatoTexto = blue+fontsize(8pt);
label("$v_1$",(v.x/2,0)+Sep*(0,-2),FormatoTexto);
label("$v_2$",(v.x,v.y/2)+Sep*(1.5,0),FormatoTexto);

// El ángulo de la recta
draw((4,0)..(4.1,0.25)..A+1.3v,1bp+orange,ArcArrow(3bp));
label("$\alpha$",(4.3,0.4),fontsize(12pt));

// El ángulo del vector de dirección
markangle("$\alpha$", radius=6mm, (1,0), (0,0), v, 0.5bp+black);
