//---------------------------------------------------------------
// Fichero:  resolucion1.asy
// Objetivo: Representar la resolución 1
// Fecha:    M.6.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Dimensiones de los ejes
real Xmin = -5, Xmax = 10, Ymin = -3, Ymax = 6, Extra = 0.5;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(5pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Definimos los tres puntos
pair A=(-2,4), B=(-5,-3), C=(7,-1);

// El resultado
pair D=A+(C-B);

// El paralelogramo
draw(A -- B -- C -- D -- A, deepgreen);

// Los puntos
pen FormatoPunto = 3bp+black;
dot(A, FormatoPunto);
dot(B, FormatoPunto);
dot(C, FormatoPunto);
dot(D, FormatoPunto);
pen FormatoTexto = black+fontsize(8pt);
label("A",A,NW,FormatoTexto);
label("B",B,SW,FormatoTexto);
label("C",C,SE,FormatoTexto);
label("D",D,NE,FormatoTexto);
