//---------------------------------------------------------------
// Fichero:  grafico6.asy
// Objetivo: Representar el gráfico 6
// Fecha:    V.2.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Grosor de las líneas
defaultpen(1);

// Dimensiones de los ejes
real Xmin = -3, Xmax = 3, Ymin = -2, Ymax = 2, Extra = 0.5;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(4pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Definimos los tres puntos y el origen
pair F=(-1,2), G=(3,1), H=(-3,-2), O=(0,0);

// Los vectores
pen FormatoTexto = black+fontsize(6pt);
draw(O -- G, 1.5bp+gray,Arrow(HookHead,5pt));
pair Pos=G/2+0.3N;
label("OG",Pos,FormatoTexto);
draw(Pos+(-0.2,0.15) -- Pos+(0.2,0.15), 0.5bp+black,Arrow(HookHead,1.5pt));
draw(O -- H, 1.5bp+gray,Arrow(HookHead,5pt));
pair Pos=H/2+0.4S;
label("OH",Pos,FormatoTexto);
draw(Pos+(-0.2,0.15) -- Pos+(0.2,0.15), 0.5bp+black,Arrow(HookHead,1.5pt));
draw(O -- (H+G), 1.5bp+deepgreen,Arrow(HookHead,5pt));
pair Pos=(H+G)/2+0.8E;
label("OG+OH",Pos,FormatoTexto);
draw(Pos+(-0.55,0.175) -- Pos+(-0.15,0.175), 0.5bp+black,Arrow(HookHead,1.5pt));
draw(Pos+(0.15,0.175) -- Pos+(0.55,0.175), 0.5bp+black,Arrow(HookHead,1.5pt));
draw(O -- F, 1.5bp+gray,Arrow(HookHead,5pt));
pair Pos=F/2+0.4W;
label("OF",Pos,FormatoTexto);
draw(Pos+(-0.2,0.15) -- Pos+(0.2,0.15), 0.5bp+black,Arrow(HookHead,1.5pt));
draw(O -- (F+H)/2, 1.5bp+deepgreen,Arrow(HookHead,5pt));
pair Pos=(F+H)/4+0.3N;
label("$\frac{1}{2}$(OG+OH)",Pos,FormatoTexto);
draw(Pos+(-0.4,0.175) -- Pos+(0,0.175), 0.5bp+black,Arrow(HookHead,1.5pt));
draw(Pos+(0.3,0.175) -- Pos+(0.7,0.175), 0.5bp+black,Arrow(HookHead,1.5pt));

// Los puntos
pen FormatoPunto = 3bp+black;
dot(F, FormatoPunto);
dot(G, FormatoPunto);
dot(H, FormatoPunto);
dot(O, FormatoPunto);
pen FormatoPunto = 5bp+deepgreen;
pen FormatoTexto = black+fontsize(6pt);
label("F",F,N,FormatoTexto);
label("G",G,E,FormatoTexto);
label("H",H,SW,FormatoTexto);
label("O",O,2N+E,FormatoTexto);
