//---------------------------------------------------------------
// Fichero:  grafico2.asy
// Objetivo: Representar el gráfico 2
// Fecha:    M.29.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Grosor de las líneas
defaultpen(1);

// Dimensiones de los ejes
real Xmin = -3, Xmax = 5, Ymin = -2, Ymax = 2, Extra = 0.5;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(5pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Definimos los tres puntos
pair A=(-1,2), B=(5,-1), C=(3,-2);

// El resultado
pair R=B+0.5*(A-C);

// Los vectores
pen FormatoTexto = black+fontsize(8pt);
draw(C -- A, 1.5bp+gray,Arrow(HookHead,5pt));
pair Pos=(C+A)/2+0.7SW;
label("CA",Pos,FormatoTexto);
draw(Pos+(-0.32,0.3) -- Pos+(0.32,0.3), 0.5bp+black,Arrow(HookHead,1.5pt));
draw(B -- R, 1.5bp+gray,Arrow(HookHead,5pt));
pair Pos=(B+R)/2+0.7NE;
label("$\frac{1}{2}$CA",Pos,FormatoTexto);
draw(Pos+(-0.14,0.3) -- Pos+(0.5,0.3), 0.5bp+black,Arrow(HookHead,1.5pt));

// Los puntos
pen FormatoPunto = 3bp+black;
dot(A, FormatoPunto);
dot(B, FormatoPunto);
dot(C, FormatoPunto);
pen FormatoPunto = 5bp+deepgreen;
dot(R, FormatoPunto);
pen FormatoTexto = black+fontsize(8pt);
label("A",A,NW,FormatoTexto);
label("B",B,SE,FormatoTexto);
label("C",C,SE,FormatoTexto);
