//---------------------------------------------------------------
// Fichero:  figura3.asy
// Objetivo: Representar la figura 3
// Fecha:    S.26.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Grosor de las líneas
defaultpen(1);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 7, Ymin = 0, Ymax = 4, Extra = 0.5;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(5pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El vector fantasma
draw((2,3) -- (7,4), 1.5bp+gray,Arrow(HookHead,5pt));
pen FormatoTexto = black+fontsize(8pt);
pair Pos=(4.5,3);
label("PQ",Pos,FormatoTexto);
draw(Pos+(-0.25,0.3) -- Pos+(0.25,0.3), 0.5bp+black,Arrow(HookHead,2pt));

// Los puntos
dot((2,3), 3bp+black);
dot((7,4), 3bp+black);
pen FormatoTexto = black+fontsize(8pt);
label("P",(2,3),2N,FormatoTexto);
label("Q",(7,4),2N,FormatoTexto);

// El vector
dot((0,0), 3bp+deepgreen);
draw((0,0) -- (5,1), 1.5bp+deepgreen,Arrow(HookHead,5pt));
pen FormatoTexto = black+fontsize(8pt);
pair Pos=(5,1)+0.5*unit((5,1));
label("PQ",Pos,FormatoTexto);
draw(Pos+(-0.25,0.3) -- Pos+(0.25,0.3), 0.5bp+black,Arrow(HookHead,2pt));

