//---------------------------------------------------------------
// Fichero:  figura4.asy
// Objetivo: Representar la figura 4
// Fecha:    M.22.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.4cm);

// Grosor de las líneas
defaultpen(1);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 7, Ymin = 0, Ymax = 4, Extra = 0.5;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(5pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Los vectores
pen FormatoTexto = black+fontsize(8pt);
dot((0,0), 3bp+deepgreen);
draw((0,0) -- (5,1), 1.5bp+deepgreen,Arrow(HookHead,5pt));
draw((2,3) -- (7,4), 1bp+gray,Arrow(HookHead,5pt));
label("$\vec{v}$",(5,1)+0.4*unit((5,1)),FormatoTexto);
label("$\vec{v}$",(4.5,3.5),S,FormatoTexto);

// Los puntos
dot((2,3), 3bp+black);
label("P",(2,3),2N,FormatoTexto);
dot((7,4), 3bp+black);
label("P+"+"$\vec{v}$",(7,4),2N,FormatoTexto);
