//---------------------------------------------------------------
// Fichero:  grafico1.asy
// Objetivo: Representar el gráfico 1
// Fecha:    V.18.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Dimensiones de los ejes
real Xmin = -2, Xmax = 9, Ymin = -3, Ymax = 4, Extra = 0.5;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(5pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Líneas auxiliares
pen Punteado = linetype(new real[] {2,2});
draw((-2,4) -- (7,1), Punteado+gray);
draw((9,-3) -- (7,1), Punteado+gray);

// Los vectores
draw((0,0)--(-1,2), 1.5bp+deepgreen,Arrow(HookHead,5pt));
draw((0,0)--(-2,4), 0.75bp+orange,Arrow(HookHead,5pt));
draw((0,0)--(3,-1), 1.5bp+deepgreen,Arrow(HookHead,5pt));
draw((0,0)--(9,-3), 0.75bp+orange,Arrow(HookHead,5pt));
draw((0,0)--(7,1), 1.5bp+deepred,Arrow(HookHead,5pt));
dot((0,0), 3bp+deepgreen);

// Los nombres de los vectores
pen FormatoTexto = blue+fontsize(8pt);
label("$2\vec{a}+3\vec{c}$",(7,1)+unit((7,1)),FormatoTexto);
label("$\vec{a}$",(-1,2),2W,FormatoTexto);
label("$2\vec{a}$",(-2,4),NW,FormatoTexto);
label("$\vec{c}$",(3,-1),2S,FormatoTexto);
label("$3\vec{c}$",(9,-3),SE,FormatoTexto);
