//---------------------------------------------------------------
// Fichero:  triangulos.asy
// Objetivo: Representar los triángulos determinados
// Fecha:    M.15.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle(), markrightangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// Los vectores
pair u=2.5*dir(30), v=2*dir(120);

// Los puntos auxiliares
pair T=(0,0), A=(u.x,0), B=(v.x,0);

// El ángulo
markangle(radius=5mm, u, T, v, 1.5bp+deepgreen);
pen FormatoTexto = blue+fontsize(8pt);
label("$\widehat{(\vec{u},\vec{v})}$",(0.15,0.5),FormatoTexto);

// Los ángulos rectos
markrightangle(u, A, T, 3mm, 0.5bp+gray);
markrightangle(v, B, T, 3mm, 0.5bp+gray);

// Los ángulos auxiliares
markangle("$\alpha$",radius=7mm, A, T, u, 1bp+blue);
markangle("$\beta$",radius=7mm, B, v, T, 1bp+blue);

// Los triángulos
draw(T -- u -- (u.x,0) -- T);
draw(T -- v -- (v.x,0) -- T);

// La separación entre las flechas y el objeto
real Sep = 0.25;

// Las flechas que marcan los segmentos
pen FormatoFlecha=mediumblue+0.5bp;
draw(T+Sep*(0,-1) -- A+Sep*(0,-1), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.25mm));
draw(T+Sep*(0,-1) -- B+Sep*(0,-1), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.25mm));
draw(u+Sep*(0.5,0) -- A+Sep*(0.5,0), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.25mm));
draw(v-Sep*(0.5,0) -- B-Sep*(0.5,0), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.25mm));

// Los puntos
pen FormatoTexto=fontsize(8pt)+Helvetica(series="n",shape="n");
pen FormatoPunto=3bp+black;
dot(T,FormatoPunto);
label("O",(0,0),S,black+FormatoTexto);
dot(u,FormatoPunto);
label("U",u,N,black+FormatoTexto);
dot(A,FormatoPunto);
label("A",A,S,black+FormatoTexto);
dot(v,FormatoPunto);
label("V",v,N,black+FormatoTexto);
dot(B,FormatoPunto);
label("B",B,S,black+FormatoTexto);

// Las componentes
pen FormatoTexto = blue+fontsize(8pt);
label("$u_1$",A/2+Sep*(0,-1.5),FormatoTexto);
label("$-v_1$",B/2+Sep*(0,-1.5),FormatoTexto);
label("$u_2$",(u+A)/2+Sep*(1,0),FormatoTexto);
label("$-v_1$",B/2+Sep*(0,-1.5),FormatoTexto);
label("$v_2$",(v+B)/2-Sep*(1,0),FormatoTexto);
