//---------------------------------------------------------------
// Fichero:  esquema.asy
// Objetivo: Representar el esquema de la situación
// Fecha:    M.15.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// Los vectores
pair u=2.5*dir(30), v=2*dir(120);

// Dimensiones de los ejes
real Xmin = -1.2, Xmax = 2.3, Ymin = 0, Ymax = 1.75, Extra = 0.1;

// Los ejes de coordenadas
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// Líneas auxiliares
draw(u -- (u.x,0), dashed+gray+0.5bp);
draw(v -- (v.x,0), dashed+gray+0.5bp);

// El ángulo
markangle(radius=5.5mm, u, (0,0), v, 1.5bp+deepgreen);
pen FormatoTexto = blue+fontsize(8pt);
label("$\widehat{(\vec{u},\vec{v})}$",(0.25,0.5),FormatoTexto);

// Los vectores
dot((0,0), 3bp+black);
draw((0,0) -- u, 1.25bp+black,Arrow(HookHead,5pt));
draw((0,0) -- v, 1.25bp+black,Arrow(HookHead,5pt));

// Los nombres de los vectores
pen FormatoTexto = blue+fontsize(10pt);
label("$\vec{u}$",u+0.15*unit(u),FormatoTexto);
label("$\vec{v}$",v+0.15*unit(v),FormatoTexto);

// Las marcas en los ejes
real Sep=0.05;
pen FormatoMarca=0.5bp+blue;
draw((u.x,Sep) -- (u.x,-Sep), FormatoMarca);
draw((Sep,u.y) -- (-Sep,u.y), FormatoMarca);
draw((v.x,Sep) -- (v.x,-Sep), FormatoMarca);
draw((Sep,v.y) -- (-Sep,v.y), FormatoMarca);

// Las componentes
pen FormatoTexto = blue+fontsize(8pt);
label("$u_{1}$",(u.x,0),2S,FormatoTexto);
label("$v_{1}$",(v.x,0),2S,FormatoTexto);
label("$u_{2}$",(0,u.y),2W,FormatoTexto);
label("$v_{2}$",(0,v.y),2W,FormatoTexto);
