//---------------------------------------------------------------
// Fichero:  suma2.asy
// Objetivo: Representar la suma de dos vectores como continuación
// Fecha:    J.10.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(7cm);

// Grosor de las líneas
defaultpen(1);

// Los vectores
pair u=(7,1), v=(2,2), s=u+v;

// Dimensiones de los ejes
real Xmin = min(0,u.x,v.x,s.x), Xmax = max(u.x,v.x,s.x);
real Ymin = min(0,u.y,v.y,s.y), Ymax = max(u.y,v.y,s.y);
real Extra = 0.5;

// El eje de abscisas
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Los vectores
dot((0,0), 3bp+deepgreen);
dot(v, 3bp+deepgreen);
draw((0,0) -- v, 1.25bp+deepgreen,Arrow(HookHead,5pt));
draw(v -- s, 1.25bp+deepgreen,Arrow(HookHead,5pt));
draw((0,0) -- s, 1.25bp+deepred,Arrow(HookHead,5pt));

// Los nombres de los vectores
pen FormatoTexto = blue+fontsize(8pt);
label("$\vec{v}$",v/2,NW,FormatoTexto);
label("$\vec{u}$",(v+s)/2,NW,FormatoTexto);
label("$\vec{u}+\vec{v}$",s/2,SE,FormatoTexto);
