//---------------------------------------------------------------
// Fichero:  modulo.asy
// Objetivo: Representar el módulo de un vector
// Fecha:    X.9.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm);

// Grosor de las líneas
defaultpen(1);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 3, Ymin = 0, Ymax = 2, Extra = 0.25;

// El eje de abscisas
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El vector
dot((0,0), 2.5bp+deepgreen);
draw((0,0)--(3,2), 1.5bp+deepgreen,Arrow(HookHead,5pt));
label("$\vec{v}$",(1.5,1),SE,blue+fontsize(12pt));

// El módulo
pair Sep = (-0.2,0.3);
pen FormatoFlecha=mediumblue+0.5bp;
draw(Sep -- (3,2)+Sep, FormatoFlecha, Arrows(HookHead,3bp), Bars(1.5mm));
label("$|\vec{v}|$",(1.5,1)+Sep,NW,blue+fontsize(12pt));
