//---------------------------------------------------------------
// Fichero:  hexagono.asy
// Objetivo: Dibujar un hexágono y tres vectores iguales
// Fecha:    M.8.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.5cm);

// Grosor de las líneas
defaultpen(1);

// El hexágono
path Hex=polygon(6);
draw(Hex);

// Los vectores
pair A=point(Hex,3), B=(0,0);
dot(A, 4bp+deepgreen);
draw(A -- B, 1.5bp+deepgreen,Arrow(HookHead,5pt));

pair A=point(Hex,2), B=point(Hex,1);
dot(A, 4bp+deepgreen);
draw(A -- B, 1.5bp+deepgreen,Arrow(HookHead,5pt));

pair A=point(Hex,4), B=point(Hex,5);
dot(A, 4bp+deepgreen);
draw(A -- B, 1.5bp+deepgreen,Arrow(HookHead,5pt));
