//---------------------------------------------------------------
// Fichero:  puntos.asy
// Objetivo: Representar dos puntos
// Fecha:    X.16.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(10cm);

// Grosor de las líneas
defaultpen(1);

// Dimensiones de los ejes
real Xmin = -4, Xmax = 6, Ymin = -1, Ymax = 3, Extra = 0.25;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(10pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Los puntos
pair O=(0,0), P=(5,1), Q=(-3,2);
dot(O, 4bp+deepgreen);
label("O",O,SE,blue+fontsize(12pt));
dot(P, 4bp+deepgreen);
label("P",P,N,blue+fontsize(12pt));
dot(Q, 4bp+deepgreen);
label("Q",Q,N,blue+fontsize(12pt));

