//---------------------------------------------------------------
// Fichero:  solucion4.asy
// Objetivo: Representar la solución 4
// Fecha:    L.5.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Grosor de las líneas
defaultpen(1);

// Dimensiones de los ejes
real Xmin = -3, Xmax = 3, Ymin = -3, Ymax = 2, Extra = 0.5;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(5pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Definimos los tres puntos y el origen
pair T=(3,2), U=(-3,-2), Z=(2,-3), O=(0,0);

// Los vectores
pen FormatoTexto = black+fontsize(8pt);
draw(Z -- U, 1.5bp+deepgreen,Arrow(HookHead,5pt));
pair Pos=(Z+U)/2+0.5SW;
label("ZU",Pos,FormatoTexto);
draw(Pos+(-0.25,0.2) -- Pos+(0.25,0.2), 0.5bp+black,Arrow(HookHead,1.5pt));
draw(T -- Z, 1.5bp+deepgreen,Arrow(HookHead,5pt));
pair Pos=(T+Z)/2+0.5SE;
label("TZ",Pos,FormatoTexto);
draw(Pos+(-0.25,0.2) -- Pos+(0.25,0.2), 0.5bp+black,Arrow(HookHead,1.5pt));

// Los puntos
pen FormatoPunto = 3bp+black;
dot(T, FormatoPunto);
dot(U, FormatoPunto);
dot(Z, FormatoPunto);
pen FormatoPunto = 5bp+deepgreen;
pen FormatoTexto = black+fontsize(8pt);
label("T",T,N,FormatoTexto);
label("U",U,W,FormatoTexto);
label("Z",Z,S,FormatoTexto);
