//---------------------------------------------------------------
// Fichero:  solucion4.asy
// Objetivo: Representar la solución 4
// Fecha:    D.4.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Grosor de las líneas
defaultpen(1);

// Dimensiones de los ejes
real Xmin = -4, Xmax = 3, Ymin = -3, Ymax = 2, Extra = 0.5;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(4pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Definimos los tres puntos
pair F=(3,0), G=(-4,-3), H=(-2,2);

// Los vectores
pen FormatoTexto = black+fontsize(8pt);
draw(H -- F, 1.5bp+deepgreen,Arrow(HookHead,5pt));
pair Pos=(H+F)/2+0.4N;
label("HF",Pos,FormatoTexto);
draw(Pos+(-0.25,0.2) -- Pos+(0.25,0.2), 0.5bp+black,Arrow(HookHead,1.5pt));
draw(H -- G, 1.5bp+deepgreen,Arrow(HookHead,5pt));
pair Pos=(H+G)/2+0.5SE;
label("HG",Pos,FormatoTexto);
draw(Pos+(-0.25,0.2) -- Pos+(0.25,0.2), 0.5bp+black,Arrow(HookHead,1.5pt));

// Los puntos
pen FormatoPunto = 3bp+black;
dot(F, FormatoPunto);
dot(G, FormatoPunto);
dot(H, FormatoPunto);
pen FormatoPunto = 5bp+deepgreen;
pen FormatoTexto = black+fontsize(8pt);
label("F",F,NE,FormatoTexto);
label("G",G,S,FormatoTexto);
label("H",H,NW,FormatoTexto);
