//---------------------------------------------------------------
// Fichero:  grafico2.asy
// Objetivo: Representar el gráfico 2
// Fecha:    D.20.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Los cinco vectores
pair m=(2,2), e=(-5,1);
pair m1=3*m, e1=2*e;
pair suma=m1+e1;

// Dimensiones de los ejes
real Xmin = -10, Xmax = 6, Ymin = -1, Ymax = 9, Extra = 0.5;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(5pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Líneas auxiliares
pen Punteado = linetype(new real[] {2,2});
draw(m1 -- suma, Punteado+gray);
draw(e1 -- suma, Punteado+gray);

// Los vectores
draw((0,0)--m, 1.5bp+deepgreen,Arrow(HookHead,5pt));
draw((0,0)--m1, 0.75bp+orange,Arrow(HookHead,5pt));
draw((0,0)--e, 1.5bp+deepgreen,Arrow(HookHead,5pt));
draw((0,0)--e1, 0.75bp+orange,Arrow(HookHead,5pt));
draw((0,0)--suma, 1.5bp+deepred,Arrow(HookHead,5pt));
dot((0,0), 3bp+deepgreen);

// Los nombres de los vectores
pen FormatoTexto = blue+fontsize(8pt);
label("$3\vec{m}+2\vec{e}$",suma,N,FormatoTexto);
label("$\vec{m}$",m,E,FormatoTexto);
label("$3\vec{m}$",m1,NE,FormatoTexto);
label("$\vec{e}$",e,N,FormatoTexto);
label("$2\vec{e}$",e1,W,FormatoTexto);
